# Sherif Cloud – Next Generation Bot Hosting

Aplikasi web hosting bot berbasis PHP dengan integrasi Pterodactyl Panel, siap deploy di cPanel.

## Struktur Folder

```
/
├── public/
│   ├── index.php
│   ├── .htaccess
│   └── assets/
│       ├── css/styles.css
│       └── js/app.js
├── app/
│   ├── Core/
│   │   ├── Auth.php
│   │   ├── Controller.php
│   │   ├── Database.php
│   │   ├── PterodactylClient.php
│   │   ├── PakasirClient.php
│   │   ├── Router.php
│   │   └── View.php
│   ├── Controllers/
│   │   ├── AdminController.php
│   │   ├── ApiController.php
│   │   ├── AuthController.php
│   │   ├── DashboardController.php
│   │   ├── PaymentController.php
│   │   └── HomeController.php
│   └── Models/
│       ├── User.php
│       ├── Package.php
│       ├── Server.php
│       └── Payment.php
├── views/
│   ├── layout/main.php
│   ├── partials/{navbar,footer}.php
│   ├── components/terminal.php
│   ├── home/{index,pricing}.php
│   ├── auth/{login,register}.php
│   ├── dashboard/index.php
│   └── admin/{index,users,packages,servers}.php
└── config/
    ├── config.php
    ├── pterodactyl.php
    └── pakasir.php
```

## Konfigurasi Database

Edit file `config/config.php`:

```php
return [
    'db' => [
        'host' => 'localhost',
        'name' => 'sherif_cloud',
        'user' => 'USER_DB_ANDA',
        'pass' => 'PASSWORD_DB_ANDA',
        'charset' => 'utf8mb4'
    ],
];
```

### Skema Database (MySQL)

Jalankan SQL berikut di phpMyAdmin:

```sql
CREATE DATABASE IF NOT EXISTS sherif_cloud CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE sherif_cloud;

CREATE TABLE users (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  email VARCHAR(191) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  is_admin TINYINT(1) NOT NULL DEFAULT 0,
  pterodactyl_id INT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE packages (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  slug VARCHAR(100) NOT NULL UNIQUE,
  price DECIMAL(10,2) NOT NULL DEFAULT 0,
  memory INT NOT NULL,
  disk INT NOT NULL,
  is_free TINYINT(1) NOT NULL DEFAULT 0
);

CREATE TABLE servers (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  user_id INT UNSIGNED NOT NULL,
  package_id INT UNSIGNED NOT NULL,
  name VARCHAR(150) NOT NULL,
  pterodactyl_id INT NULL,
  identifier VARCHAR(32) NULL,
  status VARCHAR(50) NOT NULL DEFAULT 'deploying',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id),
  FOREIGN KEY (package_id) REFERENCES packages(id)
);

CREATE TABLE payments (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  user_id INT UNSIGNED NOT NULL,
  package_id INT UNSIGNED NOT NULL,
  amount DECIMAL(10,2) NOT NULL,
  status VARCHAR(20) NOT NULL DEFAULT 'pending',
  provider VARCHAR(50) NOT NULL,
  external_id VARCHAR(191) NULL,
  redirect_url VARCHAR(191) NULL,
  reference VARCHAR(191) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id),
  FOREIGN KEY (package_id) REFERENCES packages(id)
);
```

Seed awal paket:

```sql
INSERT INTO packages (name, slug, price, memory, disk, is_free) VALUES
('Free', 'free', 0, 256, 1024, 1),
('Basic', 'basic', 15000, 512, 2048, 0),
('Pro', 'pro', 30000, 1024, 4096, 0);
```

Untuk membuat akun admin pertama, set kolom `is_admin` ke `1` pada salah satu user:

```sql
UPDATE users SET is_admin = 1 WHERE id = 1;
```

## Konfigurasi Pterodactyl API

Edit `config/pterodactyl.php`:

```php
return [
    'panel_url' => 'https://panel.domain-anda.com',
    'application_api_key' => 'API_KEY_APPLICATION',
    'client_api_key' => 'API_KEY_CLIENT',
    'application_api_path' => '/api/application',
    'client_api_path' => '/api/client',
    'default_nest_id' => 1,
    'default_egg_id' => 1,
    'default_allocation_id' => 1,
    'default_memory' => 512,
    'default_disk' => 1024,
];
```

Pastikan:

- API Application key dibuat dari panel Pterodactyl (Permissions server/user create).
- API Client key bisa generik atau per-user (untuk power action dan resource).
- `default_egg_id`, `default_allocation_id`, `default_memory`, `default_disk` disesuaikan dengan template bot Anda.

## Alur Fitur Utama

- Landing page futuristik dengan fake terminal dan live log simulasi.
- Halaman pricing menampilkan 3 paket: Free, Basic, Pro.
- Tombol `Order Now`:
  - Jika user belum login: diarahkan ke halaman login.
  - Jika sudah login:
    - Paket Free:
      - User hanya bisa mengambil paket Free 1x.
      - Create user di Pterodactyl (jika belum ada).
      - Create server di Pterodactyl dengan resource sesuai paket.
      - Menyimpan `pterodactyl_id` dan `identifier` server ke database.
    - Paket Basic/Pro:
      - Membuat record pembayaran di tabel `payments` dengan status `pending`.
      - Mengirim request ke API Pakasir untuk membuat invoice QR.
      - User diarahkan ke halaman pembayaran Pakasir.
      - Setelah pembayaran sukses, Pakasir memanggil endpoint callback.
      - Callback akan:
        - Menandai `payments.status = 'paid'`.
        - Pastikan user sudah terdaftar di Pterodactyl.
        - Create server di Pterodactyl dan menyimpan datanya di tabel `servers`.

## Integrasi Payment Gateway Pakasir

Edit `config/pakasir.php`:

```php
return [
    'enabled' => true,
    'base_url' => 'https://pakasir.com',
    'slug' => 'YOUR_PAKASIR_SLUG',
    'api_key' => 'YOUR_PAKASIR_API_KEY',
    'callback_path' => '/payment/callback'
];
```

Flow singkat:

- DashboardController@order:
  - Jika paket Free → langsung create server seperti biasa.
  - Jika paket Basic/Pro:
    - Membuat `Payment` status `pending`.
    - Memanggil `PakasirClient::createInvoice()` untuk membuat invoice.
    - Menyimpan `external_id` dan `payment_url` dari Pakasir ke tabel `payments`.
    - Redirect user ke `payment_url` (scan QR dan bayar).
- PaymentController@callback:
  - Dipanggil Pakasir setelah pembayaran sukses.
  - Mengubah status `payments.status` menjadi `paid` (hanya sekali).
  - Create user di Pterodactyl jika belum ada.
  - Create server di Pterodactyl untuk user dan paket terkait.

- Dashboard user:
  - Menampilkan list server milik user.
  - Status server, CPU, RAM, Disk di-polling tiap 5 detik via endpoint `/api/server/status`.
  - Tombol `Open Panel`, `Restart`, `Stop` yang memanggil API Client (`/api/server/power`).
  - Notifikasi kecil akan muncul jika server terdeteksi offline/down.

- Admin dashboard:
  - Ringkasan total user, paket, dan server.
  - Halaman list user, paket, dan server.

## Deploy ke cPanel

1. Zip seluruh isi folder proyek ini.
2. Upload ke File Manager cPanel, misalnya ke folder `sherif-cloud/`.
3. Pastikan struktur menjadi:

   - `sherif-cloud/public` berisi `index.php` dan `.htaccess`.

4. Di cPanel, atur Document Root domain/subdomain ke folder `public`:

   - Misal: `public_html` diarahkan ke `sherif-cloud/public`.

5. Pastikan `.htaccess` di dalam `public/` berisi:

   ```apache
   RewriteEngine On

   RewriteCond %{REQUEST_FILENAME} !-f
   RewriteCond %{REQUEST_FILENAME} !-d
   RewriteRule ^ index.php [QSA,L]
   ```

6. Edit konfigurasi:

   - `config/config.php` untuk koneksi database dan base_url.
   - `config/pterodactyl.php` untuk koneksi ke panel Pterodactyl.

7. Import SQL database:

   - Buat database dan user di cPanel.
   - Import file SQL (hasil dari bagian skema di atas) via phpMyAdmin.

8. Buka domain:

   - Landing page: `/`
   - Pricing: `/pricing`
   - Login: `/login`
   - Register: `/register`
   - Dashboard user: `/dashboard`
   - Dashboard admin: `/admin` (hanya user dengan `is_admin = 1`).

## Catatan

- Aplikasi ini tidak menggunakan framework berat (tanpa Laravel).
- Autentikasi berbasis PHP session.
- Semua manajemen server dilakukan via API Pterodactyl.

