<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;
use App\Core\DigitalOceanClient;
use App\Models\User;
use App\Models\Package;
use App\Models\Server;

class AdminController extends Controller
{
    public function index(): void
    {
        $this->requireAdmin();
        $users = User::all();
        $servers = Server::all();
        $packages = Package::all();

        $doStats = null;
        try {
            $client = new DigitalOceanClient();
            $config = require dirname(__DIR__, 2) . '/config/digitalocean.php';
            $max = $config['max_droplets'] ?? null;
            $warnThreshold = $config['warning_threshold'] ?? 0.8;
            $used = $client->countDroplets();
            if ($used !== null && $max) {
                $remaining = max($max - $used, 0);
                $ratio = $used / $max;
                $status = 'aman';
                if ($ratio >= 1) {
                    $status = 'penuh';
                } elseif ($ratio >= $warnThreshold) {
                    $status = 'warning';
                }
                $doStats = [
                    'used' => $used,
                    'max' => $max,
                    'remaining' => $remaining,
                    'status' => $status
                ];
            }
        } catch (\Throwable $e) {
            $doStats = null;
        }

        $this->render('admin/index', [
            'users' => $users,
            'servers' => $servers,
            'packages' => $packages,
            'doStats' => $doStats
        ]);
    }

    public function users(): void
    {
        $this->requireAdmin();
        $users = User::all();
        $this->render('admin/users', [
            'users' => $users
        ]);
    }

    public function packages(): void
    {
        $this->requireAdmin();
        $packages = Package::all();
        $this->render('admin/packages', [
            'packages' => $packages
        ]);
    }

    public function servers(): void
    {
        $this->requireAdmin();
        $servers = Server::all();
        $this->render('admin/servers', [
            'servers' => $servers
        ]);
    }
}
