<?php

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\PterodactylClient;
use App\Models\Server;

class ApiController extends Controller
{
    public function serverStatus(): void
    {
        $this->requireAuth();
        header('Content-Type: application/json');

        $serverId = (int) ($_GET['id'] ?? 0);
        $server = Server::findById($serverId);
        if (!$server || !$server->identifier) {
            echo json_encode(['error' => true]);
            return;
        }

        $client = new PterodactylClient();
        $resources = $client->getServerResources($server->identifier);
        if (!$resources || !isset($resources['attributes']['resources'])) {
            echo json_encode(['error' => true]);
            return;
        }

        $data = $resources['attributes']['resources'];

        echo json_encode([
            'error' => false,
            'status' => $resources['attributes']['current_state'] ?? 'unknown',
            'cpu' => $data['cpu_absolute'] ?? 0,
            'memory' => $data['memory_bytes'] ?? 0,
            'disk' => $data['disk_bytes'] ?? 0
        ]);
    }

    public function serverPower(): void
    {
        $this->requireAuth();
        header('Content-Type: application/json');

        $serverId = (int) ($_POST['id'] ?? 0);
        $signal = $_POST['signal'] ?? '';

        $server = Server::findById($serverId);
        if (!$server || !$server->identifier) {
            echo json_encode(['error' => true]);
            return;
        }

        $client = new PterodactylClient();
        $result = $client->powerAction($server->identifier, $signal);

        echo json_encode([
            'error' => $result === null
        ]);
    }
}

