<?php

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\PterodactylClient;
use App\Models\User;

class AuthController extends Controller
{
    public function showLogin(): void
    {
        $this->render('auth/login');
    }

    public function login(): void
    {
        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';

        $user = User::findByEmail($email);
        if (!$user || !password_verify($password, $user->password_hash)) {
            $this->render('auth/login', [
                'error' => 'Email atau password salah'
            ]);
            return;
        }

        Auth::login($user);
        $this->redirect('/dashboard');
    }

    public function showRegister(): void
    {
        $this->render('auth/register');
    }

    public function register(): void
    {
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';
        $passwordConfirm = $_POST['password_confirm'] ?? '';

        if ($password !== $passwordConfirm) {
            $this->render('auth/register', [
                'error' => 'Konfirmasi password tidak sesuai'
            ]);
            return;
        }

        if (User::findByEmail($email)) {
            $this->render('auth/register', [
                'error' => 'Email sudah terdaftar'
            ]);
            return;
        }

        $user = User::create($name, $email, $password);
        if (!$user) {
            $this->render('auth/register', [
                'error' => 'Gagal mendaftar'
            ]);
            return;
        }

        $client = new PterodactylClient();
        $existing = $client->findUserByEmail($email);
        if ($existing && isset($existing['id'])) {
            User::updatePterodactylId($user->id, (int) $existing['id']);
        } else {
            $parts = preg_split('/\s+/', $name);
            $firstName = $parts[0] ?? 'User';
            $lastName = isset($parts[1]) ? $parts[1] : 'Sherif';
            $createdUser = $client->createUser(
                $email,
                'user' . $user->id,
                $firstName,
                $lastName,
                $password
            );
            if ($createdUser && isset($createdUser['attributes']['id'])) {
                User::updatePterodactylId($user->id, (int) $createdUser['attributes']['id']);
            }
        }

        Auth::login($user);
        $this->redirect('/dashboard');
    }

    public function logout(): void
    {
        Auth::logout();
        $this->redirect('/');
    }
}
