<?php

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\PterodactylClient;
use App\Core\PakasirClient;
use App\Core\DigitalOceanClient;
use App\Models\Payment;
use App\Models\Package;
use App\Models\Server;
use App\Models\User;
use App\Models\VpsServer;
use App\Models\VpsPlan;

class DashboardController extends Controller
{
    public function index(): void
    {
        $this->requireAuth();
        $userData = Auth::user();
        $user = User::findById($userData['id']);
        $servers = Server::forUser($user->id);
        $vpsServers = VpsServer::forUser($user->id);
        $packages = Package::all();
        $vpsPlans = VpsPlan::all();
        $pteroConfig = require dirname(__DIR__, 2) . '/config/pterodactyl.php';

        if (!empty($vpsServers)) {
            $doClient = new DigitalOceanClient();
            foreach ($vpsServers as $vps) {
                if (!$vps->ip_address || $vps->status === 'provisioning') {
                    $droplet = $doClient->getDroplet($vps->droplet_id);
                    if ($droplet && isset($droplet['droplet'])) {
                        $dropletData = $droplet['droplet'];
                        $ip = null;
                        if (isset($dropletData['networks']['v4']) && is_array($dropletData['networks']['v4']) && count($dropletData['networks']['v4']) > 0) {
                            $ip = $dropletData['networks']['v4'][0]['ip_address'] ?? null;
                        }
                        $status = $dropletData['status'] ?? $vps->status;
                        VpsServer::updateIpAndStatus($vps->id, $ip, $status);
                        $vps->ip_address = $ip;
                        $vps->status = $status;
                    }
                }
            }
        }

        $this->render('dashboard/index', [
            'user' => $user,
            'servers' => $servers,
            'packages' => $packages,
            'panelUrl' => rtrim($pteroConfig['panel_url'], '/'),
            'vpsServers' => $vpsServers,
            'vpsPlans' => $vpsPlans
        ]);
    }

    public function order(): void
    {
        $this->requireAuth();
        $userData = Auth::user();
        $user = User::findById($userData['id']);

        $packageId = (int) ($_POST['package_id'] ?? 0);
        $package = Package::findById($packageId);
        if (!$package) {
            $this->redirect('/pricing');
        }

        if ($package->is_free) {
            if (Server::userHasFreeServer($user->id)) {
                $this->redirect('/dashboard');
            }

            $serverName = 'SherifCloud#' . $user->id . '-' . random_int(1000, 9999);
            $client = new PterodactylClient();
            $pteroUser = $user->pterodactyl_id;

            if (!$pteroUser) {
                $existing = $client->findUserByEmail($user->email);
                if ($existing && isset($existing['id'])) {
                    $pteroUser = (int) $existing['id'];
                    User::updatePterodactylId($user->id, $pteroUser);
                } else {
                    $createdUser = $client->createUser(
                        $user->email,
                        'user' . $user->id,
                        $user->name,
                        'Cloud',
                        bin2hex(random_bytes(6))
                    );
                    if ($createdUser && isset($createdUser['attributes']['id'])) {
                        $pteroUser = (int) $createdUser['attributes']['id'];
                        User::updatePterodactylId($user->id, $pteroUser);
                    }
                }
            }

            if ($pteroUser) {
                $createdServer = $client->createServer(
                    $pteroUser,
                    $serverName,
                    $package->memory,
                    $package->disk
                );

                if ($createdServer && isset($createdServer['attributes']['id'], $createdServer['attributes']['identifier'])) {
                    Server::createWithPterodactyl(
                        $user->id,
                        $package->id,
                        $serverName,
                        (int) $createdServer['attributes']['id'],
                        $createdServer['attributes']['identifier'],
                        'online'
                    );
                }
            }

            $this->redirect('/dashboard');
            return;
        }

        $reference = 'SC-' . $user->id . '-' . $package->id . '-' . time();
        $payment = Payment::createPending($user->id, $package->id, $package->price, 'pakasir', $reference);
        $pakasir = new PakasirClient();
        $invoice = $pakasir->createInvoice($payment, $user, $package);

        if ($invoice && isset($invoice['payment_url'], $invoice['external_id'])) {
            Payment::attachExternal($payment->id, $invoice['external_id'], $invoice['payment_url']);
            $this->redirect($invoice['payment_url']);
            return;
        }

        $this->redirect('/pricing');
    }
}
