<?php

namespace App\Core;

use App\Models\User;

class Auth
{
    public static function startSession(): void
    {
        $config = require dirname(__DIR__, 2) . '/config/config.php';
        if (session_status() === PHP_SESSION_NONE) {
            session_name($config['security']['session_name']);
            session_start();
        }
    }

    public static function user(): ?array
    {
        self::startSession();
        return $_SESSION['user'] ?? null;
    }

    public static function check(): bool
    {
        return self::user() !== null;
    }

    public static function login(User $user): void
    {
        self::startSession();
        $_SESSION['user'] = [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'is_admin' => (bool) $user->is_admin
        ];
    }

    public static function logout(): void
    {
        self::startSession();
        $_SESSION = [];
        if (ini_get('session.use_cookies')) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
        }
        session_destroy();
    }

    public static function isAdmin(): bool
    {
        $user = self::user();
        return $user !== null && !empty($user['is_admin']);
    }
}

