<?php

namespace App\Core;

class Router
{
    private array $routes = [
        'GET' => [],
        'POST' => []
    ];

    public function get(string $path, callable|array $handler): void
    {
        $this->routes['GET'][$this->normalizePath($path)] = $handler;
    }

    public function post(string $path, callable|array $handler): void
    {
        $this->routes['POST'][$this->normalizePath($path)] = $handler;
    }

    public function dispatch(string $uri, string $method): void
    {
        $method = strtoupper($method);
        $path = $this->getPath($uri);
        $path = $this->normalizePath($path);

        $handler = $this->routes[$method][$path] ?? null;

        if ($handler === null) {
            http_response_code(404);
            echo 'Not Found';
            return;
        }

        if (is_array($handler)) {
            $class = $handler[0];
            $action = $handler[1];
            $controller = new $class();
            $controller->{$action}();
            return;
        }

        call_user_func($handler);
    }

    private function getPath(string $uri): string
    {
        $parsed = parse_url($uri, PHP_URL_PATH);
        $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
        $base = rtrim(str_replace('\\', '/', dirname($scriptName)), '/');
        if ($base !== '' && str_starts_with($parsed, $base)) {
            $parsed = substr($parsed, strlen($base));
        }
        if ($parsed === '') {
            $parsed = '/';
        }
        return $parsed;
    }

    private function normalizePath(string $path): string
    {
        if ($path === '') {
            return '/';
        }
        if ($path[0] !== '/') {
            $path = '/' . $path;
        }
        if ($path !== '/' && str_ends_with($path, '/')) {
            $path = rtrim($path, '/');
        }
        return $path;
    }
}

