<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Package
{
    public int $id;
    public string $name;
    public string $slug;
    public float $price;
    public int $memory;
    public int $disk;
    public bool $is_free;

    public static function all(): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->query('SELECT * FROM packages ORDER BY price ASC');
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return array_map([self::class, 'fromArray'], $rows);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM packages WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function fromArray(array $data): self
    {
        $package = new self();
        $package->id = (int) $data['id'];
        $package->name = $data['name'];
        $package->slug = $data['slug'];
        $package->price = (float) $data['price'];
        $package->memory = (int) $data['memory'];
        $package->disk = (int) $data['disk'];
        $package->is_free = (bool) $data['is_free'];
        return $package;
    }
}

