<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class User
{
    public int $id;
    public string $name;
    public string $email;
    public string $password_hash;
    public int $is_admin;
    public ?int $pterodactyl_id;

    public static function findByEmail(string $email): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = :email LIMIT 1');
        $stmt->execute(['email' => $email]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function create(string $name, string $email, string $password, bool $isAdmin = false): ?self
    {
        $pdo = Database::getConnection();
        $hash = password_hash($password, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare('INSERT INTO users (name, email, password_hash, is_admin) VALUES (:name, :email, :password_hash, :is_admin)');
        $stmt->execute([
            'name' => $name,
            'email' => $email,
            'password_hash' => $hash,
            'is_admin' => $isAdmin ? 1 : 0
        ]);

        $id = (int) $pdo->lastInsertId();
        return self::findById($id);
    }

    public static function all(): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->query('SELECT * FROM users ORDER BY id DESC');
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return array_map([self::class, 'fromArray'], $rows);
    }

    public static function updatePterodactylId(int $id, int $pterodactylId): void
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('UPDATE users SET pterodactyl_id = :pid WHERE id = :id');
        $stmt->execute([
            'pid' => $pterodactylId,
            'id' => $id
        ]);
    }

    public static function fromArray(array $data): self
    {
        $user = new self();
        $user->id = (int) $data['id'];
        $user->name = $data['name'];
        $user->email = $data['email'];
        $user->password_hash = $data['password_hash'];
        $user->is_admin = (int) $data['is_admin'];
        $user->pterodactyl_id = isset($data['pterodactyl_id']) ? (int) $data['pterodactyl_id'] : null;
        return $user;
    }
}
