<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class VpsPlan
{
    public int $id;
    public string $name;
    public string $slug;
    public float $price;
    public string $size_slug;
    public int $memory;
    public int $disk;
    public int $cpu;

    public static function all(): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->query('SELECT * FROM vps_plans ORDER BY price ASC');
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return array_map([self::class, 'fromArray'], $rows);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM vps_plans WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function fromArray(array $data): self
    {
        $plan = new self();
        $plan->id = (int) $data['id'];
        $plan->name = $data['name'];
        $plan->slug = $data['slug'];
        $plan->price = (float) $data['price'];
        $plan->size_slug = $data['size_slug'];
        $plan->memory = (int) $data['memory'];
        $plan->disk = (int) $data['disk'];
        $plan->cpu = (int) $data['cpu'];
        return $plan;
    }
}

