<?php

?><section class="pt-16 pb-20">
    <div class="max-w-6xl mx-auto px-4 space-y-8">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl font-semibold">Admin Dashboard</h1>
                <p class="text-slate-400 text-sm mt-1">
                    Ringkasan user, paket, dan server Sherif Cloud.
                </p>
            </div>
        </div>

        <div class="grid md:grid-cols-4 gap-6 text-sm">
            <div class="pricing-card">
                <div class="text-slate-400 text-xs">Total User</div>
                <div class="text-3xl font-semibold mt-1">
                    <?php echo isset($users) && is_array($users) ? count($users) : 0; ?>
                </div>
            </div>
            <div class="pricing-card">
                <div class="text-slate-400 text-xs">Total Server</div>
                <div class="text-3xl font-semibold mt-1">
                    <?php echo isset($servers) && is_array($servers) ? count($servers) : 0; ?>
                </div>
            </div>
            <div class="pricing-card">
                <div class="text-slate-400 text-xs">Paket Aktif</div>
                <div class="text-3xl font-semibold mt-1">
                    <?php echo isset($packages) && is_array($packages) ? count($packages) : 0; ?>
                </div>
            </div>
            <div class="pricing-card">
                <div class="text-slate-400 text-xs">Stok VPS DigitalOcean</div>
                <div class="text-3xl font-semibold mt-1">
                    <?php if (!empty($doStats)): ?>
                        <?php echo $doStats['remaining']; ?>
                    <?php else: ?>
                        ?
                    <?php endif; ?>
                </div>
                <div class="text-[11px] text-slate-500 mt-1">
                    <?php if (!empty($doStats)): ?>
                        Terpakai <?php echo $doStats['used']; ?> / <?php echo $doStats['max']; ?> droplet
                        • Status:
                        <span class="<?php echo $doStats['status'] === 'warning' ? 'text-amber-400' : ($doStats['status'] === 'penuh' ? 'text-red-400' : 'text-emerald-400'); ?>">
                            <?php echo strtoupper($doStats['status']); ?>
                        </span>
                    <?php else: ?>
                        Tidak dapat membaca API DigitalOcean
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="grid md:grid-cols-3 gap-4 text-xs">
            <a href="<?php echo $baseUrl; ?>/admin/users" class="btn-outline text-center">Kelola User</a>
            <a href="<?php echo $baseUrl; ?>/admin/packages" class="btn-outline text-center">Kelola Paket</a>
            <a href="<?php echo $baseUrl; ?>/admin/servers" class="btn-outline text-center">Monitoring Server</a>
        </div>
    </div>
</section>
