<?php

?><section class="pt-16 pb-20">
    <div class="max-w-6xl mx-auto px-4 space-y-6 text-xs">
        <div>
            <h1 class="text-2xl font-semibold mb-1">Monitoring Server</h1>
            <p class="text-slate-400">
                Daftar seluruh server bot yang berjalan di Sherif Cloud.
            </p>
        </div>
        <div class="rounded-2xl border border-white/10 bg-black/70 p-4 overflow-x-auto">
            <table class="min-w-full border-collapse">
                <thead class="text-slate-400">
                    <tr>
                        <th class="text-left py-2 pr-4 border-b border-white/10">ID</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">User</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Nama Server</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Paket</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Status</th>
                    </tr>
                </thead>
                <tbody class="text-slate-200">
                    <?php foreach ($servers as $server): ?>
                        <tr>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $server->id; ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $server->user_id; ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($server->name); ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $server->package_id; ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($server->status); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

