<?php

?><section class="pt-16 pb-20">
    <div class="max-w-6xl mx-auto px-4 space-y-6 text-xs">
        <div>
            <h1 class="text-2xl font-semibold mb-1">Kelola User</h1>
            <p class="text-slate-400">
                Daftar seluruh user yang terdaftar di Sherif Cloud.
            </p>
        </div>
        <div class="rounded-2xl border border-white/10 bg-black/70 p-4 overflow-x-auto">
            <table class="min-w-full border-collapse">
                <thead class="text-slate-400">
                    <tr>
                        <th class="text-left py-2 pr-4 border-b border-white/10">ID</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Nama</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Email</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Role</th>
                    </tr>
                </thead>
                <tbody class="text-slate-200">
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $user->id; ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($user->name); ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($user->email); ?></td>
                            <td class="py-2 pr-4 border-b border-white/5">
                                <?php echo $user->is_admin ? 'Admin' : 'User'; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

