<?php

?><section class="pt-20 pb-24">
    <div class="max-w-md mx-auto px-4">
        <div class="mb-6 text-center">
            <h1 class="text-2xl font-semibold mb-1">Login ke Sherif Cloud</h1>
            <p class="text-slate-400 text-sm">
                Masuk untuk mengelola server bot kamu.
            </p>
        </div>
        <div class="rounded-2xl border border-white/10 bg-black/70 p-6 shadow-xl shadow-black/40">
            <?php if (!empty($error)): ?>
                <div class="mb-4 text-xs text-red-400 bg-red-950/40 border border-red-500/40 rounded-lg px-3 py-2">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            <form method="post" action="<?php echo $baseUrl; ?>/login" class="space-y-4 text-sm">
                <div class="space-y-1">
                    <label class="block text-slate-300">Email</label>
                    <input type="email" name="email" required class="w-full rounded-lg bg-slate-950/70 border border-white/10 px-3 py-2 text-sm text-slate-100 focus:outline-none focus:border-primary">
                </div>
                <div class="space-y-1">
                    <label class="block text-slate-300">Password</label>
                    <input type="password" name="password" required class="w-full rounded-lg bg-slate-950/70 border border-white/10 px-3 py-2 text-sm text-slate-100 focus:outline-none focus:border-primary">
                </div>
                <button type="submit" class="btn-primary w-full mt-2">
                    Login
                </button>
            </form>
            <p class="mt-4 text-xs text-slate-400 text-center">
                Belum punya akun?
                <a href="<?php echo $baseUrl; ?>/register" class="text-primary">Daftar sekarang</a>
            </p>
        </div>
    </div>
</section>

