<?php

?><section class="pt-16 pb-20">
    <div class="max-w-6xl mx-auto px-4 space-y-8">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl font-semibold">Hi, <?php echo htmlspecialchars($user->name); ?></h1>
                <p class="text-slate-400 text-sm mt-1">
                    Kelola semua server bot kamu dari satu dashboard.
                </p>
            </div>
            <div class="flex flex-wrap gap-3 text-xs text-slate-400">
                <div class="px-3 py-2 rounded-xl border border-emerald-500/40 bg-emerald-500/10 flex items-center gap-2">
                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                    <span>Node online</span>
                </div>
                <div class="px-3 py-2 rounded-xl border border-primary/40 bg-primary/10">
                    Panel: <a href="<?php echo $panelUrl; ?>" target="_blank" class="text-primary">Open Pterodactyl</a>
                </div>
            </div>
        </div>

        <div class="grid md:grid-cols-[2fr,1fr] gap-6">
            <div class="space-y-6">
                <div class="flex items-center justify-between">
                    <h2 class="text-sm font-semibold text-slate-200">Server kamu</h2>
                    <a href="<?php echo $baseUrl; ?>/pricing" class="text-xs text-primary">Tambah server</a>
                </div>
                <div class="rounded-2xl border border-white/10 bg-black/70 p-4 space-y-3">
                    <?php if (empty($servers)): ?>
                        <p class="text-xs text-slate-400">
                            Kamu belum punya server. Pilih paket di halaman pricing untuk membuat server baru.
                        </p>
                    <?php else: ?>
                        <div class="space-y-3">
                            <?php foreach ($servers as $server): ?>
                                <div class="rounded-xl border border-white/10 bg-slate-950/80 p-3 flex flex-col md:flex-row md:items-center md:justify-between gap-3 server-card" data-server-id="<?php echo $server->id; ?>">
                                    <div>
                                        <div class="flex items-center gap-2">
                                            <h3 class="text-sm font-semibold"><?php echo htmlspecialchars($server->name); ?></h3>
                                            <span class="text-[10px] text-slate-500 uppercase tracking-wide">
                                                #<?php echo $server->id; ?>
                                            </span>
                                        </div>
                                        <div class="text-[11px] text-slate-400 mt-1 flex flex-wrap gap-3">
                                            <span>Status:
                                                <span class="font-semibold server-status text-emerald-400">
                                                    <?php echo htmlspecialchars($server->status); ?>
                                                </span>
                                            </span>
                                            <span>CPU:
                                                <span class="server-cpu text-slate-300">0%</span>
                                            </span>
                                            <span>RAM:
                                                <span class="server-ram text-slate-300">0 MB</span>
                                            </span>
                                            <span>Disk:
                                                <span class="server-disk text-slate-300">0 MB</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex flex-wrap gap-2 text-xs">
                                        <?php if ($server->identifier): ?>
                                            <a href="<?php echo $panelUrl; ?>/server/<?php echo htmlspecialchars($server->identifier); ?>" target="_blank" class="btn-ghost">
                                                Open Panel
                                            </a>
                                            <button type="button" class="btn-ghost power-action" data-signal="restart">
                                                Restart
                                            </button>
                                            <button type="button" class="btn-ghost power-action" data-signal="stop">
                                                Stop
                                            </button>
                                        <?php else: ?>
                                            <span class="text-xs text-slate-500">
                                                Menunggu penyelesaian deploy dari Pterodactyl...
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <h2 class="text-sm font-semibold text-slate-200">VPS kamu</h2>
                        <a href="<?php echo $baseUrl; ?>/vps" class="text-xs text-primary">Order VPS</a>
                    </div>
                    <div class="rounded-2xl border border-white/10 bg-black/70 p-4 space-y-3">
                        <?php if (empty($vpsServers)): ?>
                            <p class="text-xs text-slate-400">
                                Kamu belum punya VPS. Buka halaman VPS untuk mulai sewa VPS murah.
                            </p>
                        <?php else: ?>
                            <?php
                            $planMap = [];
                            foreach ($vpsPlans as $plan) {
                                $planMap[$plan->id] = $plan;
                            }
                            ?>
                            <div class="space-y-3">
                                <?php foreach ($vpsServers as $vps): ?>
                                    <?php $plan = $planMap[$vps->vps_plan_id] ?? null; ?>
                                    <div class="rounded-xl border border-white/10 bg-slate-950/80 p-3 flex flex-col gap-2 text-xs">
                                        <div class="flex items-center justify-between">
                                            <div>
                                                <div class="flex items-center gap-2">
                                                    <h3 class="font-semibold"><?php echo htmlspecialchars($vps->name); ?></h3>
                                                    <span class="text-[10px] text-slate-500 uppercase tracking-wide">
                                                        #<?php echo $vps->id; ?>
                                                    </span>
                                                </div>
                                                <div class="text-slate-400 mt-1 flex flex-wrap gap-3">
                                                    <span>Status:
                                                        <span class="font-semibold <?php echo $vps->status === 'active' ? 'text-emerald-400' : 'text-slate-300'; ?>">
                                                            <?php echo htmlspecialchars($vps->status); ?>
                                                        </span>
                                                    </span>
                                                    <?php if ($vps->ip_address): ?>
                                                        <span>IP:
                                                            <span class="text-slate-200">
                                                                <?php echo htmlspecialchars($vps->ip_address); ?>
                                                            </span>
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="text-slate-500">Menunggu IP dari DigitalOcean...</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <?php if ($plan): ?>
                                                <div class="text-right text-slate-400">
                                                    <div><?php echo $plan->memory; ?> MB RAM</div>
                                                    <div><?php echo $plan->cpu; ?> vCPU</div>
                                                    <div><?php echo $plan->disk; ?> GB SSD</div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="space-y-4">
                <h2 class="text-sm font-semibold text-slate-200">Ringkasan paket</h2>
                <div class="rounded-2xl border border-white/10 bg-black/70 p-4 space-y-3 text-xs">
                    <?php foreach ($packages as $package): ?>
                        <div class="flex items-center justify-between">
                            <div>
                                <div class="font-semibold text-slate-100">
                                    <?php echo htmlspecialchars($package->name); ?>
                                </div>
                                <div class="text-slate-500">
                                    <?php echo $package->memory; ?> MB RAM • <?php echo $package->disk; ?> MB Disk
                                </div>
                            </div>
                            <div class="text-right">
                                <?php if ($package->is_free): ?>
                                    <div class="text-primary font-semibold">Rp0</div>
                                    <div class="text-slate-500">Gratis</div>
                                <?php else: ?>
                                    <div class="text-primary font-semibold">
                                        Rp<?php echo number_format($package->price, 0, ',', '.'); ?>
                                    </div>
                                    <div class="text-slate-500">/bulan</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
