<?php

?><section class="pt-10 pb-20">
    <div class="max-w-6xl mx-auto px-4 text-center mb-10">
        <h1 class="text-3xl md:text-4xl font-semibold mb-3">Paket Hosting Bot</h1>
        <p class="text-slate-400 text-sm md:text-base max-w-2xl mx-auto">
            Pilih paket yang sesuai dengan kebutuhan bot kamu. Mulai dari paket gratis
            untuk percobaan sampai paket Pro untuk produksi berskala besar.
        </p>
    </div>
    <div class="max-w-6xl mx-auto px-4 grid md:grid-cols-3 gap-6">
        <?php foreach ($packages as $package): ?>
            <div class="pricing-card">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold"><?php echo htmlspecialchars($package->name); ?></h2>
                    <?php if ($package->is_free): ?>
                        <span class="badge-free">FREE</span>
                    <?php else: ?>
                        <span class="badge-premium">PREMIUM</span>
                    <?php endif; ?>
                </div>
                <div class="mb-4">
                    <?php if ($package->is_free): ?>
                        <div class="text-3xl font-semibold text-primary">Rp0</div>
                        <div class="text-xs text-slate-500 mt-1">Selamanya</div>
                    <?php else: ?>
                        <div class="text-3xl font-semibold text-primary">Rp<?php echo number_format($package->price, 0, ',', '.'); ?></div>
                        <div class="text-xs text-slate-500 mt-1">per bulan</div>
                    <?php endif; ?>
                </div>
                <ul class="space-y-1 text-xs text-slate-300 mb-5">
                    <li>• Memory <?php echo $package->memory; ?> MB</li>
                    <li>• Disk <?php echo $package->disk; ?> MB</li>
                    <li>• Panel Pterodactyl</li>
                    <li>• Realtime monitoring CPU, RAM, Disk</li>
                    <?php if ($package->is_free): ?>
                        <li>• 1 bot instance</li>
                    <?php else: ?>
                        <li>• Prioritas resource dan support</li>
                    <?php endif; ?>
                </ul>
                <form method="post" action="<?php echo $baseUrl; ?>/order" class="mt-auto">
                    <input type="hidden" name="package_id" value="<?php echo $package->id; ?>">
                    <button type="submit" class="btn-primary w-full order-button" data-package="<?php echo htmlspecialchars($package->slug); ?>">
                        Order Now
                    </button>
                </form>
            </div>
        <?php endforeach; ?>
    </div>
</section>

